<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('ID'); ?></th>
                                <th><?php echo app('translator')->get('Win Rate'); ?></th>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Profit'); ?></th>
                                <th><?php echo app('translator')->get('Image'); ?></th>
                                <th><?php echo app('translator')->get('Wins'); ?></th>
                                <th><?php echo app('translator')->get('Loss'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->id); ?></td>
                                    <td><?php echo e($item->win_rate); ?></td>
                                    <td><?php echo e($item->name); ?></td>
                                    <td><?php echo e($item->profit); ?></td>
                                    <td><img src="<?php echo e($item->image); ?>" alt="Image" width="50"></td>
                                    <td><?php echo e($item->wins); ?></td>
                                    <td><?php echo e($item->loss); ?></td>
                                    <td>
                                        <a href="" class="btn btn-sm btn-outline--primary ms-1" data-bs-toggle="modal" data-bs-target="#editModal" data-id="<?php echo e($item->id); ?>" data-win_rate="<?php echo e($item->win_rate); ?>" data-name="<?php echo e($item->name); ?>" data-profit="<?php echo e($item->profit); ?>" data-image="<?php echo e($item->image); ?>" data-wins="<?php echo e($item->wins); ?>" data-loss="<?php echo e($item->loss); ?>">
                                            <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                        </a>

                                        <form action="<?php echo e(route('admin.ticket.delete', $item->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                             <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                            <button class="btn btn-sm btn-danger delete" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo app('translator')->get('Delete'); ?>">
                                                <i class="las la-trash"></i>
                                            </button>
                                           
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($items->hasPages()): ?>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($items)); ?>

                </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>

    <!-- Add Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addModalLabel"><?php echo app('translator')->get('Add Ticket'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('admin.ticket.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="name" class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="win_rate" class="form-label"><?php echo app('translator')->get('Win Rate'); ?></label>
                            <input type="text" class="form-control" id="win_rate" name="win_rate" required>
                        </div>
                      
                        <div class="mb-3">
                            <label for="profit" class="form-label"><?php echo app('translator')->get('Profit'); ?></label>
                            <input type="text" class="form-control" id="profit" name="profit" required>
                        </div>
                        <div class="mb-3">
                            <label for="image" class="form-label"><?php echo app('translator')->get('Image'); ?></label>
                            <input type="file" class="form-control" id="image" name="image" required>
                        </div>
                        <div class="mb-3">
                            <label for="wins" class="form-label"><?php echo app('translator')->get('Wins'); ?></label>
                            <input type="text" class="form-control" id="wins" name="wins" required>
                        </div>
                        <div class="mb-3">
                            <label for="loss" class="form-label"><?php echo app('translator')->get('Loss'); ?></label>
                            <input type="text" class="form-control" id="loss" name="loss" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel"><?php echo app('translator')->get('Edit Ticket'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('admin.ticket.updatecopy')); ?>" method="POST" id="editForm" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
        
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="edit_id" class="form-label"><?php echo app('translator')->get('ID'); ?></label>
                            <input type="text" class="form-control" id="edit_id" name="id" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_win_rate" class="form-label"><?php echo app('translator')->get('Win Rate'); ?></label>
                            <input type="text" class="form-control" id="edit_win_rate" name="win_rate" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_name" class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control" id="edit_name" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_profit" class="form-label"><?php echo app('translator')->get('Profit'); ?></label>
                            <input type="text" class="form-control" id="edit_profit" name="profit" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="edit_wins" class="form-label"><?php echo app('translator')->get('Wins'); ?></label>
                            <input type="text" class="form-control" id="edit_wins" name="wins" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_loss" class="form-label"><?php echo app('translator')->get('Loss'); ?></label>
                            <input type="text" class="form-control" id="edit_loss" name="loss" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save Changes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Search here...']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Search here...']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
    <button class="btn btn-sm btn-outline--primary" data-bs-toggle="modal" data-bs-target="#addModal"><?php echo app('translator')->get('Add Ticket'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $('#editModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var id = button.data('id');
        var win_rate = button.data('win_rate');
        var name = button.data('name');
        var profit = button.data('profit');
        var image = button.data('image');
        var wins = button.data('wins');
        var loss = button.data('loss');

        var modal = $(this);
        modal.find('#edit_id').val(id);
        modal.find('#edit_win_rate').val(win_rate);
        modal.find('#edit_name').val(name);
        modal.find('#edit_profit').val(profit);
        modal.find('#edit_image').val(image);
        modal.find('#edit_wins').val(wins);
        modal.find('#edit_loss').val(loss);

        var form = modal.find('form');
        var action = form.attr('action');
        form.attr('action', action.replace('id=', 'id=' + id));
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\mrsam\core\resources\views/admin/support/tickets.blade.php ENDPATH**/ ?>