<?php $__env->startSection('content'); ?>
    <div class="row justify-content-end gy-4">
        <div class="col-12">
            <div class="dashboard-header-menu">
                <div class="dashboard-header-menu__link-wrapper">
                    <a href="<?php echo e(route('user.order.open')); ?>"
                        class="dashboard-header-menu__link <?php echo e(menuActive('user.order.open')); ?>"><?php echo app('translator')->get('Open'); ?></a>
                    <a href="<?php echo e(route('user.order.completed')); ?>"
                        class="dashboard-header-menu__link   <?php echo e(menuActive('user.order.completed')); ?>"><?php echo app('translator')->get('Completed'); ?></a>
                    <a href="<?php echo e(route('user.order.canceled')); ?>"
                        class="dashboard-header-menu__link   <?php echo e(menuActive('user.order.canceled')); ?>"><?php echo app('translator')->get('Canceled'); ?></a>
                    <a href="<?php echo e(route('user.order.history')); ?>"
                        class="dashboard-header-menu__link   <?php echo e(menuActive('user.order.history')); ?>"><?php echo app('translator')->get('History'); ?></a>
                </div>
                <form class="max-w-xxxl-60 flex-grow-1 d-flex gap-2 flex-wrap">
                    <div class="flex-fill">
                        <div class="select2-wrapper">
                            <select name="order_type" class="form--select form--control submit-form-on-change select2"
                                data-minimum-results-for-search="-1">
                                <option value="" selected disabled><?php echo app('translator')->get('Order Type'); ?></option>
                                <option value="1"><?php echo app('translator')->get('All'); ?></option>
                                <option value="<?php echo e(Status::ORDER_TYPE_LIMIT); ?>" <?php if(request()->order_type == Status::ORDER_TYPE_LIMIT): echo 'selected'; endif; ?>>
                                    <?php echo app('translator')->get('Limit'); ?>
                                </option>
                                <option value="<?php echo e(Status::ORDER_TYPE_MARKET); ?>" <?php if(request()->order_type == Status::ORDER_TYPE_MARKET): echo 'selected'; endif; ?>>
                                    <?php echo app('translator')->get('Market'); ?>
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="flex-fill">
                        <div class="select2-wrapper">
                            <select class="form--select form--control submit-form-on-change select2" name="order_side"
                                data-minimum-results-for-search="-1">
                                <option value="" selected disabled><?php echo app('translator')->get('Order Side'); ?></option>
                                <option value=""><?php echo app('translator')->get('All'); ?></option>
                                <option value="<?php echo e(Status::BUY_SIDE_ORDER); ?>" <?php if(request()->order_side == Status::BUY_SIDE_ORDER): echo 'selected'; endif; ?>>
                                    <?php echo app('translator')->get('Buy'); ?>
                                </option>
                                <option value="<?php echo e(Status::SELL_SIDE_ORDER); ?>" <?php if(request()->order_side == Status::SELL_SIDE_ORDER): echo 'selected'; endif; ?>>
                                    <?php echo app('translator')->get('Sell'); ?>
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="flex-fill">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control form--control"
                                value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Pair,coin,currency...'); ?>">
                            <button type="submit" class="input-group-text bg--gradient border-0 text-white">
                                <i class="las la-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-12">
            <div class="dashboard-card">
                <table class="table <?php echo e($orders->count() ? 'table--responsive--md' : 'table--empty'); ?>">
                    <?php
                        $actionShow = request()->routeIs('user.order.open') || request()->routeIs('user.order.history');
                    ?>
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Date | Pair'); ?></th>
                            <th><?php echo app('translator')->get('Side | Type'); ?></th>
                            <th><?php echo app('translator')->get('Amount | Rate'); ?></th>
                            <th><?php echo app('translator')->get('Charge | Total'); ?></th>
                            <th><?php echo app('translator')->get('Filled'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <?php if($actionShow): ?>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="tr-<?php echo e($order->id); ?>">
                                <?php
                                    $marketCurrencySymbol = @$order->pair->market->currency->symbol;
                                ?>
                                <td>
                                    <div>
                                        <?php echo e($order->formatted_date); ?>

                                        <br>
                                        <?php echo e(@$order->pair->symbol); ?>

                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <?php echo $order->orderSideBadge; ?> <br>
                                        <?php echo $order->orderTypeBadge; ?>
                                    </div>
                                </td>
                                <td>
                                    <div class="order--amount-rate-wrapper">
                                        <span class="order--amount d-block">
                                            <span
                                                class="order--amount-value"><?php echo e(showAmount($order->amount, 8, currencyFormat: false)); ?></span>
                                            <?php if($order->status == Status::ORDER_OPEN): ?>
                                                <span class="amount-rate-update" data-order='<?php echo json_encode($order->only('amount', 'rate', 'id')) ?>'
                                                    data-update-filed="amount">
                                                    <i class="las la-edit"></i>
                                                </span>
                                            <?php endif; ?>
                                        </span>
                                        <span class="order--rate d-block">
                                            <span
                                                class="order--rate-value"><?php echo e(showAmount($order->rate, 8, currencyFormat: false)); ?></span>
                                            <?php if($order->status == Status::ORDER_OPEN): ?>
                                                <span class="amount-rate-update" data-order='<?php echo json_encode($order->only('amount', 'rate', 'id')) ?>'
                                                    data-update-filed="rate">
                                                    <i class="las la-edit"></i>
                                                </span>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <span class="d-block">
                                            <?php echo e(showAmount($order->charge, currencyFormat: false)); ?>

                                            <?php echo e(__($marketCurrencySymbol)); ?>

                                        </span>
                                        <span>
                                            <?php echo e(showAmount($order->total, currencyFormat: false)); ?>

                                            <?php echo e(__($marketCurrencySymbol)); ?>

                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <div class="progress-wrapper">
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar"
                                                style="width: <?php echo e(getAmount($order->filed_percentage)); ?>%;"
                                                aria-valuenow=" <?php echo e(getAmount($order->filed_percentage)); ?>">
                                            </div>
                                        </div>
                                        <span class="fs-10">
                                            <span><?php echo e(getAmount($order->filed_percentage)); ?>%</span> |
                                            <span><?php echo e(showAmount($order->filled_amount, currencyFormat: false)); ?></span>
                                        </span>
                                    </div>
                                </td>

                                <td> <?php echo $order->statusBadge; ?> </td>
                                <?php if($actionShow): ?>
                                    <td>
                                        <?php if($order->status == Status::ORDER_OPEN): ?>
                                            <?php
                                                $backAmount = orderCancelAmount($order);
                                                $amount = $backAmount['amount'];
                                                $chargeBackAmount = $backAmount['charge_back_amount'];
                                                $cancelMessage = __(
                                                    'Are you sure to cancel this order? after cancelling the order you will get ',
                                                );

                                                if ($order->order_side == Status::BUY_SIDE_ORDER) {
                                                    $symbol = @$order->pair->market->currency->symbol;
                                                    $cancelMessage .=
                                                        showAmount($amount, currencyFormat: false) .
                                                        '+' .
                                                        showAmount($chargeBackAmount, currencyFormat: false) .
                                                        '=' .
                                                        showAmount($amount + $chargeBackAmount, currencyFormat: false) .
                                                        __(" $symbol to your $symbol wallet");
                                                } else {
                                                    $symbol = @$order->pair->coin->symbol;
                                                    $cancelMessage .=
                                                        showAmount($amount, currencyFormat: false) .
                                                        __(" $symbol to your $symbol wallet");
                                                }
                                            ?>
                                            <div>
                                                <button type="button"
                                                    class="btn btn--danger btn--cancel outline btn--sm confirmationBtn ms-2"
                                                    data-question="<?php echo e($cancelMessage); ?>"
                                                    data-action="<?php echo e(route('user.order.cancel', $order->id)); ?>">
                                                    <i class="las la-times-circle"></i> <?php echo app('translator')->get('Cancel'); ?>
                                                </button>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo userTableEmptyMessage('order') ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($orders->hasPages()): ?>
                <?php echo e(paginateLinks($orders)); ?>

            <?php endif; ?>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isCustom' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .select2-container .select2-selection--single .select2-selection__arrow {
            right: 12px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            $('table').on('click', '.order-update-form-remove', function(e) {
                $(`.order--rate`).removeClass('d-none');
                $(`.order--amount`).removeClass('d-none');
                $(this).closest('.order-update-form').remove();
            })

            let editColumn = null;

            $('table').on('click', '.amount-rate-update', function(e) {

                $('.order-update-form').remove();
                $(`.order--rate`).removeClass('d-none');
                $(`.order--amount`).removeClass('d-none');

                editColumn = $(this).closest('td');

                let order = $(this).attr('data-order');
                order = JSON.parse(order);
                let updateField = $(this).data('update-filed');
                let action = "<?php echo e(route('user.order.update', ':id')); ?>";

                let html = `<form class="order-update-form" action="${action.replace(':id', order.id)}">
                    <input type="hidden" name="update_filed" value="${updateField}">
                    <div class="input-group">
                        <span class="input-group-text">
                            ${updateField == 'amount' ? "<?php echo app('translator')->get('Amount'); ?>" : "<?php echo app('translator')->get('Rate'); ?>"}
                        </span>
                        <input type="text" class="form--control form-control" name="${updateField}"  value="${updateField == 'amount' ? getAmount(order.amount, 8) : getAmount(order.rate, 8)}">
                        <button type="submit" class="input-group-text">
                            <i class="fas fa-check text--success"></i>
                        </button>
                        <button type="button" class="input-group-text order-update-form-remove">
                            <i class="fas fa-times text--danger"></i>
                        </button>
                    </div>
                </form>`;
                editColumn.find('.order--amount-rate-wrapper').append(html);
            });

            $('table').on('submit', '.order-update-form', function(e) {
                e.preventDefault();

                let formData = new FormData($(this)[0]);
                let action = $(this).attr('action');
                let token = "<?php echo e(csrf_token()); ?>";
                let $this = $(this);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': token
                    },
                    url: action,
                    method: "POST",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $($this).find('button[type=submit]').html(
                            `<i class="fa fa-spinner fa-spin text--success"></i>`);
                        $($this).find('button[type=button]').addClass('d-none');
                        $($this).attr(`disabled`, true);
                    },
                    complete: function() {
                        $($this).find('button[type=submit]').html(
                            `<i class="fa fa-check text--success"></i>`);
                        $($this).find('button[type=button]').removeClass('d-none');
                        $($this).attr(`disabled`, false);
                    },
                    success: function(resp) {
                        if (resp.success) {
                            editColumn.find(`.order--rate`).removeClass('d-none');
                            editColumn.find(`.order--amount`).removeClass('d-none');
                            editColumn.find('.order-update-form').remove();

                            let newOrder = editColumn.find('.amount-rate-update').data('order');
                            if (resp.data.order_amount) {
                                editColumn.find(`.order--amount-value`).text(getAmount(resp.data
                                    .order_amount));
                                newOrder.amount = getAmount(resp.data.order_amount);
                            }
                            if (resp.data.order_rate) {
                                editColumn.find(`.order--rate-value`).text(getAmount(resp.data
                                    .order_rate));
                                newOrder.rate = getAmount(resp.data.order_rate);
                            }
                            editColumn.find('.amount-rate-update').attr('data-order', JSON
                                .stringify(newOrder))
                            notify('success', resp.message);
                        } else {
                            notify('error', resp.message);
                        }
                    },
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/order/list.blade.php ENDPATH**/ ?>