<ul class="sidebar-menu-list space-y-2">
    <li class="mb-4">
        <a href="<?php echo e(route('trade')); ?>" class="w-full flex items-center justify-center py-3 px-4 rounded-lg bg-gradient-to-r from-indigo-600 to-blue-500 text-white font-medium shadow-md hover:shadow-lg transition-all hover:from-indigo-700 hover:to-blue-600">
            New Challenge
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.home')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.home')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-home"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Dashboard'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.plan.progress')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.plan.progress')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-chart-line"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Progress'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.order.history')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.order*')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-cubes"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Manage Order'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.trade.history')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.trade.history')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-chart-bar"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Trade History'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.plan.history')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive(['user.plan.history', 'user.plan.list'])); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-cube"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Plan History'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.wallet.list')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.wallet*')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-wallet"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Manage Wallet'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.deposit.history')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.deposit.history')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-credit-card"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Payment History'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.withdraw.history')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.withdraw.history')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-hand-holding-usd"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Withdraw History'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.transactions')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.transactions')); ?>">
            <span class="icon text-indigo-600"><i class="fa fa-exchange-alt"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Transaction'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('ticket.index')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('ticket*')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-headset"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Support Ticket'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.twofactor')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-indigo-50 hover:text-indigo-700 transition-all <?php echo e(menuActive('user.twofactor')); ?>">
            <span class="icon text-indigo-600"><i class="fas fa-shield-alt"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Security'); ?></span>
        </a>
    </li>

    <li class="sidebar-menu-list__item">
        <hr class="border-gray-200 my-2" />
    </li>

    <li class="sidebar-menu-list__item">
        <a href="<?php echo e(route('user.logout')); ?>" class="sidebar-menu-list__link flex items-center gap-3 py-3 px-4 rounded-lg text-gray-700 hover:bg-red-50 hover:text-red-600 transition-all">
            <span class="icon text-red-500"><i class="fas fa-sign-out-alt"></i></span>
            <span class="text font-medium"><?php echo app('translator')->get('Log Out'); ?></span>
        </a>
    </li>
</ul><?php /**PATH C:\wamp64\www\volttraders\core\resources\views/templates/basic/partials/sidebar.blade.php ENDPATH**/ ?>