<?php $__env->startSection('panel'); ?>
    <form action="<?php echo e(route('admin.plan.save', @$plan->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card mb-4">
                    <div class="card-header">
                        <div class="d-flex flex-wrap justify-content-between">
                            <h5 class="title"><?php echo e(__($pageTitle)); ?></h5>
                            <button class="btn btn--dark btn--sm addPhase" type="button"> <i class="las la-plus"></i> <?php echo app('translator')->get('Add Phase'); ?></button>
                        </div>
                    </div>
                    <div class="card-body" style="display: none">
                        <div class="row">
                            <div class="col-md-6 col-xl-3">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" name="name" value="<?php echo e(old('name', @$plan->name)); ?>" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6 col-xl-3">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Price'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" min="0" name="price" value="<?php echo e(old('price', @$plan ? getAmount(@$plan->price) : '')); ?>" class="form-control" required>
                                        <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xl-3">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Fund'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" min="0" name="fund" value="<?php echo e(old('fund', getAmount(@$plan->fund))); ?>" class="form-control" required>
                                        <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xl-3">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Conversion'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="1" name="conversion" value="<?php echo e(old('conversion', @$plan->conversion)); ?>" class="form-control" required>
                                        <span class="input-group-text"><?php echo app('translator')->get('Times'); ?></span>
                                    </div>
                                    <small class="text--pink text--small"><?php echo app('translator')->get('How many exchanges are allowed between wallets?'); ?></small>
                                </div>
                            </div>
                            <div class="col-md-6 col-xl-3">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Daily Loss'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" min="0" name="max_daily_loss" value="<?php echo e(getAmount(@$plan->max_daily_loss)); ?>" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-xl-3">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Overall Loss'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" min="0" name="max_overall_loss" value="<?php echo e(getAmount(@$plan->max_overall_loss)); ?>" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="planPhase">
                    <?php $__currentLoopData = @$plan->planPhases ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-3" data-phase_count="<?php echo e($loop->iteration); ?>">
                            <div class="card-header">
                                <div class="card-header">
                                    <div class="d-flex flex-wrap justify-content-between">
                                        <h5 class="title"><?php echo e(__($phase->name)); ?></h5>
                                        <div>
                                            <button class="btn btn--dark btn--sm addLogin" type="button"> <i class="las la-plus"></i> <?php echo app('translator')->get('Add Logic'); ?></button>
                                            <button class="btn btn--danger btn--sm removePhaseBtn" type="button"> <i class="las la-trash"></i> <?php echo app('translator')->get('Delete Phase'); ?></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <input type="hidden" name="old_phase[<?php echo e($loop->iteration); ?>]" value="<?php echo e($phase->id); ?>">
                                    <div class="row phaseLogic">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo app('translator')->get('Phase Name'); ?></label>
                                                <input type="text" name="phase_name[<?php echo e($loop->iteration); ?>]" value="<?php echo e(old("phase_name[$loop->iteration]", $phase->name)); ?>" class="form-control" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo app('translator')->get('Profit Share'); ?></label>
                                                <div class="input-group">
                                                    <input type="number" step="any" name="phase_profit[<?php echo e($loop->iteration); ?>]" value="<?php echo e(old("phase_profit[$loop->iteration]", getAmount($phase->profit))); ?>" class="form-control" required>
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </div>
                                        </div>

                                        <?php $__currentLoopData = $phase->phaseLogics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-6 logicBox">
                                                <input type="hidden" name="old_logic[<?php echo e($loop->parent->iteration); ?>][<?php echo e($loop->iteration); ?>]" value="<?php echo e($logic->id); ?>">
                                                <div class="form-group">
                                                    <label><?php echo app('translator')->get('Logic'); ?></label>
                                                    <div class="d-flex">
                                                        <select name="logic[<?php echo e($loop->parent->iteration); ?>][<?php echo e($loop->iteration); ?>]" class="form-control select2-basic" required>
                                                            <option hidden value=""><?php echo app('translator')->get('Select One'); ?></option>
                                                            <?php $__currentLoopData = $logicBoxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logicBox): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($logicBox->id); ?>" <?php if($logicBox->id == $logic->logic_box_id): echo 'selected'; endif; ?>><?php echo e(__($logicBox->name)); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <button class="btn btn--danger btn--sm ms-2 removeLogicBox" type="button"><i class="las la-trash m-0"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="card">
                    <div class="card-footer">
                        <button class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.plan.list')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.plan.list')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $attributes = $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $component = $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            let phaseCount = `<?php echo e(@$plan->planPhases?->count() ?? 0); ?>`;

            $('.addPhase').on('click', function() {
                let phaseHtml = `<div class="card mb-3" data-phase_count="${++phaseCount}">
                                    <div class="card-header">
                                        <div class="card-header">
                                            <div class="d-flex flex-wrap justify-content-between">
                                                <h5 class="title"><?php echo app('translator')->get('New Phase'); ?></h5>
                                                <div>
                                                    <button class="btn btn--dark btn--sm addLogin" type="button"> <i class="las la-plus"></i> <?php echo app('translator')->get('Add Logic'); ?></button>
                                                    <button class="btn btn--danger btn--sm removePhaseBtn" type="button"> <i class="las la-trash"></i> <?php echo app('translator')->get('Delete Phase'); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body cardBody-${phaseCount}">
                                            <div class="row phaseLogic">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="required"><?php echo app('translator')->get('Phase Name'); ?></label>
                                                        <input type="text" name="phase_name[${phaseCount}]" class="form-control" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="required"><?php echo app('translator')->get('Profit Share'); ?></label>
                                                        <div class="input-group">
                                                            <input type="number" step="any" name="phase_profit[${phaseCount}]" class="form-control" required>
                                                            <span class="input-group-text">%</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 logicBox">
                                                    <div class="form-group">
                                                        <label class="required"><?php echo app('translator')->get('Logic'); ?></label>
                                                        <select name="logic[${phaseCount}][1]" class="form-control select2-basic" required>
                                                            <option hidden value=""><?php echo app('translator')->get('Select One'); ?></option>
                                                            <?php $__currentLoopData = $logicBoxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logicBox): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($logicBox->id); ?>"><?php echo e(__($logicBox->name)); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>`;

                $('.planPhase').append(phaseHtml);
                $('html, body').animate({
                    scrollTop: $(document).height()
                }, 'slow');

                $('.select2-basic').select2({
                    dropdownParent: $(`.cardBody-${phaseCount}`)
                });
            });

            $(document).on('click', '.removePhaseBtn', function() {
                $(this).closest('.card').remove();
            });

            function updateAvailableOptions($phase) {
                let selectedIds = $phase.find('select[name^="logic["]').map(function() {
                    return $(this).val();
                }).get().filter(id => id);

                $phase.find('select[name^="logic["]').each(function() {
                    let $select = $(this);
                    let currentValue = $select.val();

                    $select.find('option').each(function() {
                        let $option = $(this);
                        let optionValue = $option.val();

                        if (selectedIds.includes(optionValue) && optionValue !== currentValue) {
                            $option.hide();
                        } else {
                            $option.show();
                        }
                    });

                    $select.select2();
                });
            }

            $('.planPhase .card').each(function() {
                updateAvailableOptions($(this));
            });

            $(document).on('click', '.addLogin', function() {
                let $card = $(this).closest('.card');
                let currentPhase = $card.data('phase_count');
                let alreadyAddedPhase = $card.find('.logicBox').length + 1;

                let selectedLogicIds = $card.find('select[name^="logic["]').map(function() {
                    return $(this).val();
                }).get().filter(id => id); 

                let optionsHtml = '<option hidden value=""><?php echo app('translator')->get('Select One'); ?></option>';
                <?php $__currentLoopData = $logicBoxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logicBox): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    if (!selectedLogicIds.includes("<?php echo e($logicBox->id); ?>")) {
                        optionsHtml += `<option value="<?php echo e($logicBox->id); ?>"><?php echo e(__($logicBox->name)); ?></option>`;
                    }
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                let logicHtml = `<div class="col-md-6 logicBox logicBox-${currentPhase}-${alreadyAddedPhase}">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Logic'); ?></label>
                            <div class="d-flex">
                                <select name="logic[${currentPhase}][${alreadyAddedPhase}]" class="form-control select2-basic" required>
                                    ${optionsHtml}
                                </select>
                                <button class="btn btn--danger btn--sm ms-2 removeLogicBox" type="button"><i class="las la-trash m-0"></i></button>
                            </div>
                        </div>
                    </div>`;

                $card.find('.phaseLogic').append(logicHtml);

                $(`.logicBox-${currentPhase}-${alreadyAddedPhase} .select2-basic`).select2({
                    dropdownParent: $(`.logicBox-${currentPhase}-${alreadyAddedPhase}`)
                });

                updateAvailableOptions($card);
            });

            $(document).on('click', '.removeLogicBox', function() {
                let $card = $(this).closest('.card');
                $(this).closest('.logicBox').remove();
                updateAvailableOptions($card);
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\mrsam\core\resources\views/admin/plan/add.blade.php ENDPATH**/ ?>