<?php $__env->startSection('content'); ?>
    <div class="row gy-4">
        <div class="col-lg-12">
            <form class="d-flex flex-wrap justify-content-end mb-3 gap-3">
                <div class="select2-wrapper">
                    <select class="form--select form--control submit-form-on-change select2" name="trade_side">
                        <option value="" selected disabled><?php echo app('translator')->get('Trade Side'); ?></option>
                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                        <option value="<?php echo e(Status::BUY_SIDE_TRADE); ?>" <?php if(request()->trade_side == Status::BUY_SIDE_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Buy'); ?></option>
                        <option value="<?php echo e(Status::SELL_SIDE_TRADE); ?>" <?php if(request()->trade_side == Status::SELL_SIDE_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Sell'); ?></option>
                    </select>
                </div>

                <div class="input-group w-auto">
                    <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>"
                        placeholder="<?php echo app('translator')->get('Pair,coin,currency...'); ?>">
                    <button type="submit" class="input-group-text bg--gradient border-0 text-white">
                        <i class="las la-search"></i>
                    </button>
                </div>
            </form>
        </div>
        <div class="col-lg-12">
            <div class="dashboard-card">
                <table class="table <?php echo e($trades->count() ? 'table--responsive--md' : 'table--empty'); ?>">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Order Date | Pair'); ?></th>
                            <th><?php echo app('translator')->get('Trade Date'); ?></th>
                            <th><?php echo app('translator')->get('Trade Side'); ?></th>
                            <th><?php echo app('translator')->get('Rate'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div>
                                        <?php echo e($trade->order->formatted_date); ?>

                                        <br>
                                        <?php echo e(@$trade->order->pair->symbol); ?>

                                    </div>
                                </td>
                                <td><?php echo e(showDateTime($trade->created_at)); ?></td>
                                <td> <?php  echo $trade->tradeSideBadge; ?> </td>
                                <td>
                                    <?php echo e(showAmount($trade->rate, 8, currencyFormat: false)); ?>

                                    <?php echo e(@$trade->order->pair->market->currency->symbol); ?>

                                </td>
                                <td> <?php echo e(showAmount($trade->amount, currencyFormat: false)); ?>

                                    <?php echo e(@$trade->order->pair->coin->symbol); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo userTableEmptyMessage('trade') ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($trades->hasPages()): ?>
                <?php echo e(paginateLinks($trades)); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .select2-wrapper {
            width: 200px;
        }

        @media (max-width: 575px) {
            .select2-wrapper {
                flex-grow: 1;
            }

            .input-group {
                width: 100% !important;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/order/trade_history.blade.php ENDPATH**/ ?>